jQuery(document).ready(function($){
    $('#aichat-submit').on('click', function(){
        let userMessage = $('#aichat-user-input').val().trim();
        if(!userMessage){
            return;
        }

        // Append user message to chat box
        $('#aichat-box-agent').append(
            '<div class="user-message">' + $('<div/>').text(userMessage).html() + '</div>'
        );

        // Clear input
        $('#aichat-user-input').val('');

        // Send to server via AJAX
        $.ajax({
            url: comment2aichat_obj.ajax_url,
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'comment2aichat_process_chat',
                security: comment2aichat_obj.nonce,
                message: userMessage
            },
            success: function(response){
                if(response.success){
                    let reply = response.data.reply;
                    $('#aichat-box-agent').append(
                        '<div class="assistant-message">' + $('<div/>').text(reply).html() + '</div>'
                    );
                } else {
                    // Error
                    $('#aichat-box-agent').append(
                        '<div class="assistant-message">Error: ' + response.data.error + '</div>'
                    );
                }
            },
            error: function(xhr){
                $('#aichat-box-agent').append(
                    '<div class="assistant-message">Error: Unable to reach server.</div>'
                );
            }
        });
    });
});
